#include "specifics.h"
#include "sys_log.h"
#include "stdlib.h"

void fatal(const char * const reason) {
    sys::log("*** fatality: %s\n", reason);
    #if defined WINDOWS
        MessageBeep(MB_ICONHAND);
        MessageBoxA(0, reason, "fatality", MB_ICONHAND); // MB_ICONWARNING);
    #endif
    exit(-1);
}

void bail(const char * const reason, const int exitcode) {
    sys::log("\n\nbail: %s\n", reason);
    //sys::log("\n-- hit return --\n\n"); getchar();
    exit(exitcode);
}
